import { WebPlugin, AppPluginWeb, } from "@capacitor/core";
const { remote, shell, ipcRenderer } = require("electron");
const webApp = new AppPluginWeb();
export class AppPluginElectron extends WebPlugin {
    constructor() {
        super({
            name: "App",
            platforms: ["electron"],
        });
        this.launchUrl = { url: "" };
        this.listeners = {};
        this.windowListeners = {};
        // @ts-ignore
        ipcRenderer.on("appUrlOpen", (event, url) => {
            this.launchUrl = { url };
            this.notifyListeners("appUrlOpen", { url });
        });
    }
    exitApp() {
        let w = remote.getCurrentWindow();
        w && w.close();
        throw new Error("App quit");
    }
    canOpenUrl(_options) {
        return Promise.resolve({ value: true });
    }
    openUrl(options) {
        shell.openExternal(options.url);
        return Promise.resolve({ completed: true });
    }
    getLaunchUrl() {
        return Promise.resolve(this.launchUrl);
    }
    getState() {
        return webApp.getState();
    }
}
const App = new AppPluginElectron();
export { App };
//# sourceMappingURL=app.js.map